<?php 
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/ArticoliDalBlog.php";
    
    if(isset($_GET["id"])) {
        $datiArticoliDalBlog = new ArticoliDalBlog($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $datiArticoliDalBlog->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione visualizzatore articoli dal blog</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Visualizzatore articoli creato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        
                        if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Visualizzatore articoli modificato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-12">
                        <div class="form-row justify-content-between mb-3">
                            <div class="col-auto d-flex">
                                <nav aria-label="breadcrumb" class="align-self-center">
                                    <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                        <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                        <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                        <li class="breadcrumb-item"><a href="index.php">Articoli dal blog</a></li>
                                        <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($datiArticoliDalBlog)? $datiArticoliDalBlog->getNome() : "Nuovo visualizzatore di articoli dal blog"))?></li>
                                    </ol>
                                </nav>
                            </div>
                            <div class="col-auto text-right">
                                <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                        <div class="card mb-4 box-shadow-lite">
                            <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                <input type="text" class="d-none" name="operazione" value="<?php echo((isset($datiArticoliDalBlog) ? "modifica" : "crea")); ?>">
                                <input type="text" class="d-none" name="id" value="<?php echo((isset($datiArticoliDalBlog) ? $datiArticoliDalBlog->getId() : "0")); ?>">
                                
                                <div class="card-body">
                                    <div class="row">
                                        <div class="form-group col-md-6">
                                            <label >Nome:</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo((isset($datiArticoliDalBlog) ? $datiArticoliDalBlog->getNome() : "")) ?>" placeholder="Nome visualizzatore articoli">
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <label >Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($datiArticoliDalBlog) && $datiArticoliDalBlog->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                        </div>
                                        
                                        <div class="w-100"></div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Categoria articoli</label>
                                            <select class="form-control" id="idCategoria" name="categoria" onchange="mostraInputCateogrie()">
                                                <option value="0">Tutte le categorie</option>
                                                <option value="-1" <?php echo((isset($datiArticoliDalBlog) && $datiArticoliDalBlog->getCategoria()==-1) ? "selected" : "") ?>>Ultimo articolo delle categorie indicate</option>
                                                <?php 
                                                    $queryCategoria = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo' AND categoriaMadre=0 ORDER BY posizione ASC";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryCategoria);
                                                    while($categoria = $risNomi->fetch_assoc()) {
                                                        if(isset($datiArticoliDalBlog) && $categoria["id"]==$datiArticoliDalBlog->getCategoria()) {
                                                            echo"<option value=\"{$categoria["id"]}\" SELECTED>{$categoria["nome"]}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$categoria["id"]}\">{$categoria["nome"]}</option>";
                                                        }
                                                        
                                                        // cerco e stampo eventuali sottocategorie
                                                        $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                                                        $risSottoCategorie   = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                        while($sottoCategoria = $risSottoCategorie->fetch_assoc()) {
                                                            if($datiArticoliDalBlog->getCategoria() == $sottoCategoria["id"]) {
                                                                echo"<option value=\"{$sottoCategoria["id"]}\" selected> - {$sottoCategoria["nome"]}</option>";						
                                                            }
                                                            else {
                                                                echo"<option value=\"{$sottoCategoria["id"]}\"> - {$sottoCategoria["nome"]}</option>";
                                                            }

                                                            // cerco e stampo eventuali sottocategorie della sottocategoria
                                                            $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo' AND categoriaMadre={$sottoCategoria["id"]} ORDER BY posizione ASC";
                                                            $risSottoCategorieSottoCategorie= $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                            while($sottoCategoriaDellaSottoCategoria = $risSottoCategorieSottoCategorie->fetch_assoc()) {
                                                                if($datiArticoliDalBlog->getCategoria() == $sottoCategoriaDellaSottoCategoria["id"]) {
                                                                    echo"<option value=\"{$sottoCategoriaDellaSottoCategoria["id"]}\" selected> - - {$sottoCategoriaDellaSottoCategoria["nome"]}</option>";						
                                                                }
                                                                else {
                                                                    echo"<option value=\"{$sottoCategoriaDellaSottoCategoria["id"]}\"> - - {$sottoCategoriaDellaSottoCategoria["nome"]}</option>";
                                                                }
                                                            }
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Scegli la categoria degli articoli da visualizzare</small>
                                        </div>
                                        
                                                                                
                                        <div id="divCategorieIndicate" class="<?php echo(isset($datiArticoliDalBlog) && $datiArticoliDalBlog->getCategoria()==-1 ? "col-md-3 form-group" : "d-none") ?>">
                                            <label for="select1">Categorie indicate</label>
                                            <input type="text" class="form-control" name="categorieIndicate" value="<?php echo(isset($datiArticoliDalBlog) ? $datiArticoliDalBlog->getCategorieIndicate() : ""); ?>">
                                            <small class="form-text text-muted">Inserisci gli id delle categorie separati da una virgola, ad esempio: 1,5,8</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Escludi categoria</label>
                                            <select class="form-control" name="escludiCategoria">
                                                <option value="-1">Nessuna</option>
                                                <?php 
                                                    $queryCategoria = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo' AND categoriaMadre=0 ORDER BY posizione ASC";
                                                    $risNomi = $geecomDb->eseguiQueryLettura($queryCategoria);
                                                    while($categoria = $risNomi->fetch_assoc()) {
                                                        if(isset($datiArticoliDalBlog) && $categoria["id"]==$datiArticoliDalBlog->getEscludiCategoria()) {
                                                            echo"<option value=\"{$categoria["id"]}\" SELECTED>{$categoria["nome"]}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$categoria["id"]}\">{$categoria["nome"]}</option>";
                                                        }
                                                        
                                                        // cerco e stampo eventuali sottocategorie
                                                        $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo' AND categoriaMadre={$categoria["id"]} ORDER BY posizione ASC";
                                                        $risSottoCategorie   = $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                        while($sottoCategoria = $risSottoCategorie->fetch_assoc()) {
                                                            if($datiArticoliDalBlog->getEscludiCategoria() == $sottoCategoria["id"]) {
                                                                echo"<option value=\"{$sottoCategoria["id"]}\" selected> - {$sottoCategoria["nome"]}</option>";						
                                                            }
                                                            else {
                                                                echo"<option value=\"{$sottoCategoria["id"]}\"> - {$sottoCategoria["nome"]}</option>";
                                                            }

                                                            // cerco e stampo eventuali sottocategorie della sottocategoria
                                                            $querySottoCategorie = "SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaArticolo' AND categoriaMadre={$sottoCategoria["id"]} ORDER BY posizione ASC";
                                                            $risSottoCategorieSottoCategorie= $geecomDb->eseguiQueryLettura($querySottoCategorie);
                                                            while($sottoCategoriaDellaSottoCategoria = $risSottoCategorieSottoCategorie->fetch_assoc()) {
                                                                if($datiArticoliDalBlog->getEscludiCategoria() == $sottoCategoriaDellaSottoCategoria["id"]) {
                                                                    echo"<option value=\"{$sottoCategoriaDellaSottoCategoria["id"]}\" selected> - - {$sottoCategoriaDellaSottoCategoria["nome"]}</option>";						
                                                                }
                                                                else {
                                                                    echo"<option value=\"{$sottoCategoriaDellaSottoCategoria["id"]}\"> - - {$sottoCategoriaDellaSottoCategoria["nome"]}</option>";
                                                                }
                                                            }
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Esclude gli articoli della categoria selezionata</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Lingua articoli</label>
                                            <select class="form-control" name="lingua">
                                                <option value="">tutte</option>
                                                <?php 
                                                    foreach($lingue as $lingua) {
                                                        if(isset($datiArticoliDalBlog) && $lingua==$datiArticoliDalBlog->getLingua()) {
                                                            echo"<option value=\"{$lingua}\" SELECTED>{$lingua}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$lingua}\">{$lingua}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Imposta un filtro per lingua sugli articoli</small>
                                        </div>
                                        
                                        <div class="w-100"></div>
                                        
                                        <div id="divNumeroArticoli" class="<?php echo(isset($datiArticoliDalBlog) && $datiArticoliDalBlog->getCategoria()!=-1 ? "col-md-3 form-group" : "d-none") ?>">
                                            <label for="">Numero articoli</label>
                                            <input type="number" class="form-control" id="numeroArticoli" name="numeroArticoli" aria-describedby="nome Slider" value="<?php echo((isset($datiArticoliDalBlog) ? $datiArticoliDalBlog->getNumeroArticoli() : "1")) ?>" placeholder="Numero articoli" required>
                                            <small class="form-text text-muted">Scegli il numero di articoli da visualizzare</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Articoli per riga</label>
                                            <select class="form-control" name="dimensioneDivSingoloArticolo">
                                                <?php 
                                                    $dimenisioniSingoloArticolo = array("col-lg-8 mx-auto"=>1,"col-md-6"=>2,"col-md-4"=>3,"col-md-6 col-lg-3"=>4);
                                                    foreach($dimenisioniSingoloArticolo as $dimensione=>$numeroArticoli) {
                                                        if(isset($datiArticoliDalBlog) && $dimensione==$datiArticoliDalBlog->getDimensioneDivSingoloArticolo()) {
                                                            echo"<option value=\"{$dimensione}\" SELECTED>{$numeroArticoli}</option>";						
                                                        }
                                                        else {
                                                            echo"<option value=\"{$dimensione}\">{$numeroArticoli}</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Scegli il numero di articoli da mostrare su una sola riga a risoluzione desktop</small>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label for="">Etichetta pulsante altri articoli</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="etichettaPulsanteALtriArticoli" aria-describedby="Etichetta pulsante altri articoli" value="<?php echo((isset($datiArticoliDalBlog) ? $datiArticoliDalBlog->getEtichettaPulsanteALtriArticoli() : "")) ?>" placeholder="Etichetta pulsante altri articoli">
                                            <small class="form-text text-muted">Lascia vuoto se non vuoi mostrare il pulsante</small>
                                        </div>
                                        
                                        <div class="w-100"></div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Mostra nome</label>
                                            <input type="checkbox" class="js-switch" name="mostraTitoloComponente"  value="si" <?php echo((isset($datiArticoliDalBlog) && $datiArticoliDalBlog->getMostraTitoloComponente()=="si") ? "checked":"") ?>>
                                        </div>
                                        
                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Mostra immagini</label>
                                            <input type="checkbox" class="js-switch" name="mostraImmagini" value="si" <?php echo((isset($datiArticoliDalBlog) && $datiArticoliDalBlog->getMostraImmagini()=="si") ? "checked":"") ?>>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <label class="d-block">Mostra testo</label>
                                            <input type="checkbox" class="js-switch" name="mostraTesto" value="si" <?php echo((isset($datiArticoliDalBlog) && $datiArticoliDalBlog->getMostraTesto()=="si") ? "checked":"") ?>>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="card-footer">
                                <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <script>
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $datiArticoliDalBlog->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $datiArticoliDalBlog->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var nome = $('#nomeElemento').val();
                var link = $('#linkElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $datiArticoliDalBlog->getId() ?>,
                        nome:nome,
                        link:link
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $datiArticoliDalBlog->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function mostraInputCateogrie() {
                var categoria = document.getElementById("idCategoria").value;
                if(categoria==-1) {            
                    document.getElementById("divCategorieIndicate").className = "col-md-3 form-group";
                }
                else {
                    document.getElementById("divCategorieIndicate").className = "d-none";
                }
            }
        </script>
    </body>
</html>